#ifndef SYMBOL_H
#define SYMBOL_H
#ifndef UNIV_H
#include "univ.h"
#endif

#include "dtype.h"

class Stmt; class SrcText;

struct Range {
	long	lo;
	long	hi;
};

class Symbol : public PadRcv {				// Symbol
	friend	SymTab;
	friend	SunosSymTab;
	friend	CoffSymTab;
	Symbol	*hashlink;
public:
	int	disc();
	int	ok();
		Symbol(Symbol*,Symbol*,char*);
	Symbol	*parent;
	Symbol	*child;
	Symbol	*rsib;
	Symbol	*lsib;
	char	*_text;
virtual	char	*text(long=0);
	Range	range;
	char	*dump();
	Source	*source();
};

const LEAVE = 0, SHOW = 1, HIDE = 2;

class Var : public Symbol {				// Var
	friend	Expr;
	friend	UType;
	short	_disc;
	short	showorhide;
	Index	carte();
	void	reformat(long);
	char	*fmtlist();
	void	showutype(UType*);
public:
		Var(class SymTab*,class Block*,Var*,UDisc,char*);
		~Var();
	int	disc();
	int	ok();
	DType	type;
	void	show(int=LEAVE, Attrib=0);
};

class BlkVars : public PadRcv {					// BlkVars
class	Block	*b;		// next block
	Var	*v;		// prev variable
PUBLIC(BlockVars,U_BLKVARS)
	Var	*gen();
		BlkVars(Block*i);
};

class Block : public Symbol {				// Block
	friend	BlkVars;
	friend	SymTab;
	friend	SunosSymTab; friend Sunos5SymTab;
	friend	CoffSymTab;
	friend	MipsSymTab; friend class FileDesc;
	friend	MccSymTab;
	friend	IeeeSymTab;
	Var	*var;
PUBLIC(Block,U_BLOCK)
		Block(SymTab*,Symbol*,Block*,char*);
		~Block();
class	Stmt	*stmt;
};	

class Source : public Symbol {				// Source
	friend	SunosSymTab;
	friend	CoffSymTab;
	friend	MccSymTab;
	friend	FileDesc;
	friend	IeeeSymTab;
	friend	Func;
	Func	*linefunc;
	Stmt	*linestmt;
PUBLIC(Source,U_SOURCE)
		Source(SymTab*,Source*,char*,long);
virtual		~Source();
	SrcText	*srctext;
	SymTab	*symtab;
	Block	*blk;
	char	*filename();
	Func	*funcafter(int,int);
	Stmt	*stmtafter(Func*,int);
	char	*text(long=0);
	char	*bname;
	char	*dir;
};
	
class Func : public Symbol {				// Func
	friend	SunosSymTab; friend Sunos5SymTab;
	friend	CoffSymTab;
	friend	MipsSymTab; friend class FileDesc;
	friend	MccSymTab;
	friend	IeeeSymTab;
	friend	Mac32Core;
	friend	I386Core;
	long	begin;
	long	size;
	long	lnnoptr;				// coff
	long	regsave;
	Block	*_blk;
	Source	*typeinfo;
	char	*namewithargs;
	void	gather();
PUBLIC(Func,U_FUNC)
		Func(SymTab*,char*,Source*,long);
		~Func();
	Block	*blk();
	Block	*blk(long);
	DType	type;
	Range	lines;
	Stmt	*stmt(long);	
	char	*text(long=0);
	char	*textwithargs();
	Var	*argument(int);
	int	regused(int);
};

#define Q_BPT   ((Expr*)1)	
class Stmt : public Symbol {				// Stmt
	friend	SunosSymTab;
	friend	CoffSymTab;
	friend	Instr;
class	Process	*process;
class	Pad	*srcpad();
	void	error(char*);
	char	*contextsearch(char*,int);
PUBLIC(Stmt,U_STMT)
		Stmt(SymTab*,Block*,Stmt*);
		~Stmt();
	void	asmblr();
	void	select(long=0);
	char	*text(long=0);
	short	lineno;
	short	hits;
class	Expr	*condition;
	Bls	*condtext;
	void	dobpt(int);
	void	settrace();
	void	openframe();
	char	*kbd(char*);
	char	*help(long);
	void	conditional(Expr*);
	char	*srcline();
	Func	*func();
	char	*journal(Bls&);
};

class UType : public Symbol {				// UType
	friend	SunosSymTab; friend SunosType;
	friend	CoffSymTab;
	friend	MccSymTab;
	friend	TypMems;
	friend	Var;		// for symtab
	friend	MipsSymTab;
	friend	IeeeSymTab;
	SymTab	*symtab;
	long	begin;
	long	size;
	char	*canspecial;
	Var	*mem;
	void	gather();
	void	display();
PUBLIC(UType,U_UTYPE)
		UType(SymTab*,long,long,char*);
virtual		~UType();
	DType	type;
	Source	*src;
	Index	carte(enum Op);
	void	show(int=LEAVE, Attrib=0);
};

class TypMems : public PadRcv {				// TypMems
	char	pub_filler[8];
	UType	*ut;
	Var	*v;			// prev
PUBLIC(TypMems,U_TYPMEMS)
		TypMems(UType *);
	Var	*gen();
};

#endif
